#import "PMKeyCodesController.h"


typedef struct {
    NSString *character;
    unsigned short keyCode;
} PMFKeyCode;

typedef struct {
    NSUInteger characterCode;
    unsigned short keyCode;
} PMSKeyCode;


NSString *PMStringForKeyCode(unsigned short theKeyCode) {
	static NSMutableDictionary *singletonCharacterMap = nil;
	if (!singletonCharacterMap) {
		singletonCharacterMap = [[NSMutableDictionary dictionary] retain];
		static PMFKeyCode singletonFKeyCodes[] = {
			{@"F1", 122},
			{@"F2", 120},
			{@"F3", 99},
			{@"F4", 118},
			{@"F5", 96},
			{@"F6", 97},
			{@"F7", 98},
			{@"F8", 100},
			{@"F9", 101},
			{@"F10", 109},
			{@"F11", 103},
			{@"F12", 111},
			{@"F13", 105},
			{@"F14", 107},
			{@"F15", 113},
			{@"Space", 49},
			{@"Escape", 53},
			{@"Help", 114}
		};
		static int singletonNumberOfFKeyCodes = sizeof(singletonFKeyCodes) / sizeof(PMFKeyCode);
		static PMSKeyCode singletonSKeyCodes[] = {
			{0x21E5, 48},	// tab
			{0x232B, 51},	// backspace
			{0x21B5, 36},	// return
			{0x2305, 76},	// enter
			{0x2326, 117},	// forward delete

			{0x21E0, 123},	// left
			{0x21E2, 124},	// right
			{0x21E3, 125},	// down
			{0x21E1, 126},	// up

			{0x2196, 115},	// start
			{0x2198, 119},	// end
			{0x21DE, 116},	// page up
			{0x21DF, 121}	// page down
		};
		static int singletonNumberOfSKeyCodes = sizeof(singletonSKeyCodes) / sizeof(PMSKeyCode);
		int	i;
		for (i = 0; i<singletonNumberOfFKeyCodes; i++) {
			[singletonCharacterMap setObject: singletonFKeyCodes[i].character forKey: [NSNumber numberWithUnsignedShort: singletonFKeyCodes[i].keyCode]];
		}
		for (i = 0; i<singletonNumberOfSKeyCodes; i++) {
			[singletonCharacterMap setObject: [NSString stringWithFormat: @"%C", singletonSKeyCodes[i].characterCode] forKey: [NSNumber numberWithUnsignedShort: singletonSKeyCodes[i].keyCode]];
		}
	}
	return [singletonCharacterMap objectForKey: [NSNumber numberWithUnsignedShort: theKeyCode]];
}

NSString *PMKeyboardCaseCharacter(NSString *theCharacter) {
	static NSString *singletonEligibleCharacters = nil;
	if (!singletonEligibleCharacters) {
		singletonEligibleCharacters = [[NSString stringWithFormat: @"abcdefghijklmnopqrstuvwxyz%c%c%cABCDEFGHIJKLMNOPQRSTUVWXYZ%c%c%c", '', '', '', '', '', ''] retain];
	}
	return (([singletonEligibleCharacters rangeOfString: theCharacter].location==NSNotFound) ? [theCharacter lowercaseString] : [theCharacter uppercaseString]);
}

BOOL PMImportUserDefaults(NSString *theDomain) {
	BOOL didImport = NO;
	NSUserDefaults *theUserDefaults = [NSUserDefaults standardUserDefaults];
	NSString *theImportCheckKey = [NSString stringWithFormat: @"Imported User Defaults: %@", theDomain];
	if (![theUserDefaults boolForKey: theImportCheckKey]) {
		NSAutoreleasePool *theLocalAutoreleasePool = [[NSAutoreleasePool alloc] init];
		NSDictionary *theImportedSettings = [[[[NSUserDefaults alloc] init] autorelease] persistentDomainForName: theDomain];
		NSEnumerator *theEnumerator = [theImportedSettings keyEnumerator];
		NSString *aKey;
		while (aKey = [theEnumerator nextObject]) {
			[theUserDefaults setObject: [theImportedSettings objectForKey: aKey] forKey: aKey];
			didImport = YES;
		}
		[theUserDefaults setBool: YES forKey: theImportCheckKey];
		[theLocalAutoreleasePool release];
	}
	return didImport;
}


@interface PMEventEaterApplication: NSApplication

	{
	}

@end

@implementation PMEventEaterApplication

	- (void)sendEvent: (NSEvent*)theEvent {
		id theDelegate = [self delegate];
		if ([theDelegate respondsToSelector: @selector(eatEvent:)] && [theDelegate eatEvent: theEvent]) {
			return;
		}
		[super sendEvent: theEvent];
	}

@end


@implementation PMKeyCodesController

	- (void)applicationDidFinishLaunching: (NSNotification*)notification {
		PMImportUserDefaults(@"de.petermaurer.Key Codes");
		[logPanel setFloatingPanel: YES];
		[logPanel setHidesOnDeactivate: NO];
		[self logString: [NSString stringWithFormat: @"\n%@", [[NSBundle mainBundle] objectForInfoDictionaryKey: @"CFBundleGetInfoString"]] attributes: [NSDictionary dictionaryWithObjectsAndKeys: [NSFont systemFontOfSize: 10], NSFontAttributeName, [NSColor disabledControlTextColor], NSForegroundColorAttributeName, nil]];
		[verboseSwitch setState: ([[NSUserDefaults standardUserDefaults] boolForKey: @"Verbose"] ? NSOnState : NSOffState)];
		[logPanel display];
		[logPanel orderFrontRegardless];
		[NSApp activateIgnoringOtherApps: YES];
	}

	- (BOOL)windowShouldClose: (id)sender {
		[NSApp terminate: nil];
		return YES;
	}

	- (IBAction)toggleVerbose: (id)sender {
		[[NSUserDefaults standardUserDefaults] setBool: ([verboseSwitch state]==NSOnState) forKey: @"Verbose"];
	}

	- (void)logString: (NSString*)theString attributes: (NSDictionary*)theAttributes {
		NSMutableAttributedString *logText = [log textStorage];
		[logText appendAttributedString: [[[NSAttributedString alloc] initWithString: theString attributes: theAttributes] autorelease]];
		[log scrollRangeToVisible: NSMakeRange([logText length], 0)];
	}

	- (void)logCharacter: (NSString*)theCharacter key: (NSString*)theKey code: (NSInteger)theKeyCode modifiers: (NSUInteger)theModifiers kind: (NSString*)theKindOfEvent {
		static NSDictionary *singletonKeyAttributes = nil;
		if (!singletonKeyAttributes) {
			singletonKeyAttributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont systemFontOfSize: 12], NSFontAttributeName, [NSColor disabledControlTextColor], NSForegroundColorAttributeName, nil];
		}
		static NSDictionary *singletonValueAttributes = nil;
		if (!singletonValueAttributes) {
			singletonValueAttributes = [[NSDictionary alloc] initWithObjectsAndKeys: [NSFont systemFontOfSize: 12], NSFontAttributeName, [NSColor textColor], NSForegroundColorAttributeName, nil];
		}
		[self logString: [NSString stringWithFormat: @"\n\n%@", theKindOfEvent] attributes: singletonValueAttributes];
		if ([theCharacter length]>0) {
			[self logString: @"\nCharacters:\t" attributes: singletonKeyAttributes];
			[self logString: theCharacter attributes: singletonValueAttributes];
			[self logString: @"\nUnicode:\t\t" attributes: singletonKeyAttributes];
			unichar firstCharacter = [theCharacter characterAtIndex: 0];
			[self logString: [NSString stringWithFormat: @"%d / %p", (int)firstCharacter, (void*)((int)firstCharacter)] attributes: singletonValueAttributes];
		}
		[self logString: @"\nKeys:\t\t" attributes: singletonKeyAttributes];
		[self logString: theKey attributes: singletonValueAttributes];
		if (theKeyCode>=0) {
			[self logString: @"\nKey Code:\t" attributes: singletonKeyAttributes];
			[self logString: [NSString stringWithFormat: @"%d / %p", theKeyCode, (void*)theKeyCode] attributes: singletonValueAttributes];
		}
		[self logString: @"\nModifiers:\t" attributes: singletonKeyAttributes];
		[self logString: [NSString stringWithFormat: @"%d / %p", theModifiers, (void*)theModifiers] attributes: singletonValueAttributes];
	}

	- (BOOL)eatEvent: (NSEvent*)theEvent {
		NSEventType theEventType = [theEvent type];
		if ((theEventType==NSKeyDown) || (((theEventType==NSKeyUp) || (theEventType==NSFlagsChanged)) && ([verboseSwitch state]==NSOnState))) {
			unsigned short theKeyCode = [theEvent keyCode];
			NSUInteger theModifiers = [theEvent modifierFlags];
			NSMutableString *theReadableKeyString = [NSMutableString string];
			if ((theModifiers & NSShiftKeyMask)!=0) {
				[theReadableKeyString appendString: [NSString stringWithFormat: @"%C", 0x21E7]];
			}
			if ((theModifiers & NSControlKeyMask)!=0) {
				[theReadableKeyString appendString: [NSString stringWithFormat: @"%C", 0x005E]];
			}
			if ((theModifiers & NSAlternateKeyMask)!=0) {
				[theReadableKeyString appendString: [NSString stringWithFormat: @"%C", 0x2325]];
			}
			if ((theModifiers & NSCommandKeyMask)!=0) {
				[theReadableKeyString appendString: [NSString stringWithFormat: @"%C", 0x2318]];
			}
			if (theEventType==NSFlagsChanged) {
				[self logCharacter: nil key: theReadableKeyString code: -1 modifiers: theModifiers kind: @"Modifier Change"];
			} else {
				NSString *theCharacter = PMStringForKeyCode(theKeyCode);
				[theReadableKeyString appendString: ((theCharacter) ? theCharacter : PMKeyboardCaseCharacter([theEvent charactersIgnoringModifiers]))];
				[self logCharacter: [theEvent characters] key: theReadableKeyString code: (NSInteger)theKeyCode modifiers: theModifiers kind: ((theEventType==NSKeyDown) ? ([theEvent isARepeat] ? @"Key Down (Repeated)" : @"Key Down") : @"Key Up")];
			}
			return YES;
		}
		return NO;
	}

@end
